#include <stdio.h>
#include <stdlib.h>
#include <string.h>

typedef struct celula {
  char* texto;
  struct celula* esq;
  struct celula* dir;
} celula;

void imprimir_arvore(celula* raiz, int nivel) {
  if (!raiz) return;
  for (int i = 0; i < nivel; i++){
    printf("  ");
  }
  printf("%s\n", raiz->texto);
  imprimir_arvore(raiz->esq, nivel + 1);
  imprimir_arvore(raiz->dir, nivel + 1);
}

celula* novo_no(const char* texto) {
  celula* n = malloc(sizeof(celula));
  //strdup aloca memória e copia a string
  n->texto = strdup(texto);
  n->esq = NULL;
  n->dir = NULL;
  return n;
}

// Função para ler uma linha do arquivo e retornar o nível e o texto
int ler_linha(FILE* f, int* filhos, char* texto) {
  char linha[1024];
  //lê a linha, se acabou o arquivo retorna 0
  if (!fgets(linha, sizeof(linha), f)) return 0;

  //%[^\n] significa ler até o caractere de nova linha
  sscanf(linha, "%d;%[^\n]", filhos, texto);
  return 1;
}

// Função recursiva que constrói a árvore
celula* ler_arvore(FILE* f) {
  int filhos;
  char texto [1024];

  //le a linha, se acabou o arquivo a arvore é vazia
  if (!ler_linha(f, &filhos, texto)) return NULL;

  //Cria um novo nó
  celula* no = novo_no(texto);
  printf("Lendo nó: '%s' com %d filhos\n", texto, filhos);
  if (filhos >= 1){
    no->esq = ler_arvore(f);
  }
  if (filhos == 2){
    no->dir = ler_arvore(f);
  }
  return no;
}

void jogar(celula* no) {
  if (!no) return;
    
  //Se não tem nenhum filho, é final, só imprime e acaba
  if (!no->esq && !no->dir) {
    printf("\n%s\n", no->texto);
    return;
  }

  //Se só tem um filho, não é escolha, imprime e segue
  if (no->esq && !no->dir) {
    printf("\n%s\n", no->texto);
    jogar(no->esq);
    return;
  } 

  //Tem dois filhos, pergunta a escolha
  printf("\n%s\n", no->texto);
  printf("1) %s\n", no->esq->texto);
  printf("2) %s\n", no->dir->texto);
  
  int esc = -1;
  while (esc < 1 || esc > 2) {
    printf("> ");
    scanf("%d", &esc);
  }

  if (esc == 1){
    jogar(no->esq);
  }else{
    jogar(no->dir);
  }
}


int main(int argc, char* argv[]) {
  if (argc < 2) {
    fprintf(stderr, "Uso: %s arquivo.txt\n", argv[0]);
    return 1;
  }
  FILE* f = fopen(argv[1], "r");
  if (!f) {
    perror("Erro ao abrir arquivo");
    return 1;
  }

  celula* raiz = ler_arvore(f);
  fclose(f);

  //imprimir_arvore(raiz, 0);

  printf("\nBem-vindo à aventura!\n");
  jogar(raiz);

  //liberar(raiz);
  return 0;
}
